/*
	Hook function
*/

#ifndef HOOK_H
#define HOOK_H

#include <pspkernel.h>
#include <psputilsforkernel.h>
#include <pspsdk.h>
#include <stdbool.h>
#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

/*-----------------------------------------------
	^錾
-----------------------------------------------*/
/* PSPLinkq */
struct hook_syscall_table_header
{
	struct hook_syscall_table_header *next; /* ̃e[u(ĉ?)ւ̃|C^ */
	unsigned int offset;                    /* offset to substract from syscall code (substractĉ?) */
	unsigned int num;                       /* e[ȗSGg */
	unsigned int size;                      /* e[uŜ̃TCY(oCgP) */
};

/*-----------------------------------------------
	֐
-----------------------------------------------*/
/*
	hookFindExportAddr
	
	W[ACuANID֐̃GNX|[gAhXԂB
	ʏ̃W[񋟂֐̃tbŃAŎ擾AhXhookFunc()ɓn΂悢cc͂B
	
	@param: const char *modname
		W[B
	
	@param: const char *libname
		CuB
	
	@params: unsigned int nid
		NIDB
	
	@return: void**
		GNX|[gAhXB
*/
void **hookFindExportAddr( const char *modname, const char *libname, unsigned int nid );

/*
	hookFindSyscallAddr
	
	tbN֐VXeR[łꍇ́A
	hookFindExportAddr()œAhXɂ̊֐ɓnB
	
	@param: void **addr
		hookFindExportAddr()œAhXB
	
	@return: void**
		VXeR[AhXB
*/
void **hookFindSyscallAddr( void **addr );

/*
	hookFunc
	
	tbNsB
	
	@param: void **addr
		hookFindExportAddr()A邢hookFindSyscallAddr()œAhXB
	
	@param: void *hookfunc
		u֐̃|C^B
*/
void hookFunc( void **addr, void *hookfunc );

#ifdef __cplusplus
}
#endif

#endif
